﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.Status;

namespace StanUrzadzeniaPrzenosnego
{
    public partial class Form1 : Form
    {
        bool sledzenieZmian = false;

        public Form1(string id)
        {
            InitializeComponent();

            aktywujPowiadomienia(false);

            this.sledzenieZmian = (id == "");
            if (sledzenieZmian)
            {
                Refresh();
                dezaktywujPowiadomieniaStale();                
            }
            else
            {
                this.Text += "!";
                this.MinimizeBox = false;

                SystemState s = new SystemState(id);
                if (s.ApplicationLaunchId == id) zmianaStanu(s, null);
                else Refresh();                
            }
        }

        static string JestBrak(bool wartoscLogiczna)
        {
            return wartoscLogiczna?"Jest":"Brak";
        }

        static string TakNie(bool wartoscLogiczna)
        {
            return wartoscLogiczna?"Tak":"Nie";
        }

        string[] pobierzInformacjeOStanieUrzadzenia()
        {
            List<string> lista = new List<string>();
            lista.Add("Stan urządzenia (" + SystemState.Time.ToString() + "):");
            lista.Add("Właściciel: " + SystemState.OwnerName);
            lista.Add("");

            lista.Add("Orientacja urządzenia: " + SystemState.DisplayRotation.ToString());
            lista.Add("Urządzenie zablokowane: " + TakNie(SystemState.DeviceLocked));

            string stanBaterii;
            switch (SystemState.PowerBatteryState)
            {
                case BatteryState.Charging: stanBaterii = "Ładowanie"; break;
                case BatteryState.Critical: stanBaterii = "Krytyczny"; break;
                case BatteryState.Low: stanBaterii = "Niski"; break;
                case BatteryState.Normal: stanBaterii = "Normalny"; break;
                case BatteryState.NotPresent: stanBaterii = "Brak"; break;
                default: stanBaterii = "Nieznany"; break;
            }
            lista.Add("Stan baterii: " + stanBaterii);

            string poziomBaterii;
            switch (SystemState.PowerBatteryStrength)
            {
                case BatteryLevel.VeryLow: poziomBaterii = "Bardzo niski"; break;
                case BatteryLevel.Low: poziomBaterii = "Niski"; break;
                case BatteryLevel.Medium: poziomBaterii = "Średni"; break;
                case BatteryLevel.High: poziomBaterii = "Wysoki"; break;
                case BatteryLevel.VeryHigh: poziomBaterii = "Bardzo wysoki"; break;
                default: poziomBaterii = "Nieznany"; break;
            }            
            lista.Add("Poziom naładowania baterii: " + poziomBaterii);
            int poziomBateriiLiczba = (int)SystemState.GetValue(SystemProperty.PowerBatteryStrength);
            lista.Add("Poziom naładowania baterii: " + poziomBateriiLiczba.ToString());
            progressBar1.Value = poziomBateriiLiczba;

            lista.Add("");

            lista.Add("Ilość nieprzeczytanych wiadomości SMS: " + SystemState.MessagingSmsUnread.ToString());
            lista.Add("Ilość nieprzeczytanych listów e-mail: " + SystemState.MessagingTotalEmailUnread.ToString());
            lista.Add("");

            lista.Add("Karta WiFi: " + JestBrak(SystemState.WiFiStateHardwarePresent));
            lista.Add("WiFi wlaczone: " + TakNie(SystemState.WiFiStatePowerOn));
            lista.Add("Połączenie WiFi: " + TakNie(SystemState.WiFiStateConnected));            
            lista.Add("");

            lista.Add("Aparat fotograficzny: " + JestBrak(SystemState.CameraPresent));
            lista.Add("Aparat zablokowany: " + TakNie(!SystemState.CameraEnabled));                        

            return lista.ToArray();
        }

        public override void Refresh()
        {
            base.Refresh();

            try
            {
                listBox1.Items.Clear();
                string[] wlasnosci = pobierzInformacjeOStanieUrzadzenia();
                foreach (string wlasnosc in wlasnosci)
                    listBox1.Items.Add(wlasnosc);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd przy odczycie stanu urządzenia!\n"+exc.Message);
            }
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Refresh();
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            Close();
        }

        #region Powiadamianie o zmianach
        List<SystemState> powiadomienia = new List<SystemState>(7);
        //string idPowiadomienia = "Zmiana stanu";        
        string idOrientacjaEkranu = "Zmiana stanu orientacji ekranu";
        string idSMS = "Zmiana stanu SMS";
        string idEmail = "Zmiana stanu e-mail";        
        string idBateriaStan = "Zmiana stanu baterii";
        string idBateriaPoziom = "Zmiana poziomu baterii";
        string idWifi = "Zmiana stanu WiFi";        

        private void aktywujPowiadomienia(bool powiadomienieTrwale)
        {
            string sciezkaDoPlikuAplikacji = System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase;

            SystemState s;
            s = new SystemState(SystemProperty.DisplayRotation);
            s.Changed += new ChangeEventHandler(zmianaStanu);
            if (powiadomienieTrwale) s.EnableApplicationLauncher(idOrientacjaEkranu, sciezkaDoPlikuAplikacji, Q(idOrientacjaEkranu));
            powiadomienia.Add(s);
            
            s = new SystemState(SystemProperty.MessagingSmsUnread);
            s.Changed += new ChangeEventHandler(zmianaStanu);
            if (powiadomienieTrwale) s.EnableApplicationLauncher(idSMS,sciezkaDoPlikuAplikacji,Q(idSMS));
            powiadomienia.Add(s);
            s = new SystemState(SystemProperty.MessagingTotalEmailUnread);
            s.Changed += new ChangeEventHandler(zmianaStanu);
            if (powiadomienieTrwale) s.EnableApplicationLauncher(idEmail,sciezkaDoPlikuAplikacji,Q(idEmail));
            powiadomienia.Add(s);

            s = new SystemState(SystemProperty.PowerBatteryStrength);
            s.Changed += new ChangeEventHandler(zmianaStanu);
            if (powiadomienieTrwale) s.EnableApplicationLauncher(idBateriaPoziom,sciezkaDoPlikuAplikacji,Q(idBateriaPoziom));
            powiadomienia.Add(s);
            s = new SystemState(SystemProperty.PowerBatteryState);
            s.Changed += new ChangeEventHandler(zmianaStanu);
            if (powiadomienieTrwale) s.EnableApplicationLauncher(idBateriaStan,sciezkaDoPlikuAplikacji,Q(idBateriaStan));
            powiadomienia.Add(s);

            s = new SystemState(SystemProperty.WiFiStateConnected);
            s.Changed += new ChangeEventHandler(zmianaStanu);
            if (powiadomienieTrwale) s.EnableApplicationLauncher(idWifi,sciezkaDoPlikuAplikacji,Q(idWifi));
            powiadomienia.Add(s);
        }

        static string Q(string tekst)
        {
            return "\"" + tekst + "\"";
        }

        void dezaktywujPowiadomieniaStale()
        {
            SystemState.DisableApplicationLauncher(idOrientacjaEkranu);
            SystemState.DisableApplicationLauncher(idSMS);
            SystemState.DisableApplicationLauncher(idEmail);
            SystemState.DisableApplicationLauncher(idBateriaStan);
            SystemState.DisableApplicationLauncher(idBateriaPoziom);
            SystemState.DisableApplicationLauncher(idWifi);
        }

        bool wyswietlKomunikat = false;

        private void zmianaStanu(object sender, ChangeEventArgs args)
        {
            Refresh();

            SystemState zmienionyStan = (SystemState)sender;
            string s1 = "Zmieniona własność: " + zmienionyStan.Property.ToString();
            string s2 = "Nowa wartość: " + zmienionyStan.CurrentValue;
            if (wyswietlKomunikat) MessageBox.Show(s1 + "\n" + s2);
            else
            {
                listBox1.Items.Add("");
                listBox1.Items.Add("-----");
                listBox1.Items.Add("");
                listBox1.Items.Add(s1);
                listBox1.Items.Add(s2);
            }
        }        
        #endregion

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            if (!sledzenieZmian) return;

            DialogResult wybor = MessageBox.Show(
                  "Czy chcesz uruchamiać tę aplikację w przypadku zmiany stanu urządzenia?",
                  "Monitorowanie stanu?",
                  MessageBoxButtons.YesNoCancel,
                  MessageBoxIcon.Question,
                  MessageBoxDefaultButton.Button2);
            switch(wybor)
            {
                case DialogResult.Yes:
                    aktywujPowiadomienia(true);
                    break;
                case DialogResult.No:
                    dezaktywujPowiadomieniaStale();
                    break;
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
            }            
        }        
    }
}